#include <QtGui>

#include "DrawERDlg.h"
#include "mode1/erdiagram/Canvas.h"
#include "mode1/erdiagram/Table.h"
#include "IntroModeSelectDlg.h"
#include "tableAttributeDlg.h"
#include "mode1/DrawERDlg.h"
#include "mode1/RelationInfo.h"
#include "MainForm.h"
#include "ConnectionForm.h"
#include "DatabaseTree.h"

DrawERDlg::DrawERDlg(QWidget *parent)
: QDialog(parent, Qt::Window)
{	
	this->a = 0;

	this->canvas = new Canvas(this);
    this->canvas->setSceneRect(QRectF(0, 0, 800, 800));
    this->erView = new QGraphicsView(canvas);

	createActions();
	createMenus();
	createToolbars();
	
	connect(this->canvas, SIGNAL(itemInserted(Table *)), this, SLOT(ItemInserted(Table *)));
	
	backBtn		= new QPushButton(tr("ڷ"));
	applyBtn	= new QPushButton(tr(""));
	cancelBtn	= new QPushButton(tr(""));

	relaitonCardiMode = 0;
	
	connect(backBtn, SIGNAL(clicked()), this, SLOT(clickBack()));
	connect(applyBtn, SIGNAL(clicked()), this, SLOT(clickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(clickCancel()));
	
	QHBoxLayout *toollayout = new QHBoxLayout;
	toollayout->addWidget(erToolbar);

	toollayout->setAlignment(Qt::AlignLeft);
	
	QHBoxLayout * btnLayout = new QHBoxLayout;
	btnLayout->addWidget(backBtn);
	btnLayout->addWidget(applyBtn);
	btnLayout->addWidget(cancelBtn);
	btnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);
	
    QVBoxLayout *erTableBoxLayout = new QVBoxLayout;
	erTableBoxLayout->addWidget(erMenuBar);
	erTableBoxLayout->addLayout(toollayout);
	erTableBoxLayout->addWidget(erView);
	erTableBoxLayout->addLayout(btnLayout);
    setLayout(erTableBoxLayout);
	
	setGeometry(100,100,1000,700);
	
    setWindowTitle(tr(" ̺ "));
	
	//this->setModal(true);
	
	//qDebug() << "modeSelect";
	this->uniqueInstance = this;
}

DrawERDlg::~DrawERDlg()
{
}

void DrawERDlg::createActions()
{
    deleteAct = new QAction(QIcon("images/delete.png"),tr("&Delete"), this);
    deleteAct->setShortcut(tr("Delete"));
    deleteAct->setStatusTip(tr("Delete item from diagram"));
	//    connect(deleteAct, SIGNAL(triggered()), this, SLOT(deleteItem()));
	
    exitAct = new QAction(tr("E&xit"), this);
    exitAct->setShortcut(tr("Ctrl+X"));
    exitAct->setStatusTip(tr("Quit Scenediagram example"));
    connect(exitAct, SIGNAL(triggered()), this, SLOT(close()));
	
    aboutAct = new QAction(tr("A&bout"), this);
    aboutAct->setShortcut(tr("Ctrl+B"));

	saveAct = new QAction(tr("&Save"), this);
	connect(saveAct, SIGNAL(triggered()), this->canvas, SLOT(Save()));

	openAct = new QAction(tr("&Open"), this);
	connect(openAct, SIGNAL(triggered()), this->canvas, SLOT(Open()));
    //connect(aboutAct, SIGNAL(triggered()), this, SLOT(about()));
}

void DrawERDlg::createMenus()
{
	//  ޴ ߰κ
	erMenuBar = new QMenuBar();
	fileMenu = erMenuBar->addMenu(tr("&File"));
	fileMenu->addAction(openAct);
	fileMenu->addAction(saveAct);
    fileMenu->addAction(exitAct);
	
    itemMenu = erMenuBar->addMenu(tr("&Item"));
    itemMenu->addAction(deleteAct);
    itemMenu->addSeparator();
	
    aboutMenu = erMenuBar->addMenu(tr("&Help"));
    aboutMenu->addAction(aboutAct);
}

void DrawERDlg::createToolbars()
{
	//erToolbar
	pointerToolButton = new QToolButton;
    pointerToolButton->setCheckable(true);
    pointerToolButton->setChecked(true);
    pointerToolButton->setIcon(QIcon("images/pointer.png"));
	
	tableToolButton = new QToolButton;
    tableToolButton->setCheckable(true);
    tableToolButton->setIcon(QIcon("images/Table.png"));
	
	lineToolButton1 = new QToolButton;
    lineToolButton1->setCheckable(true);
    lineToolButton1->setIcon(QIcon("images/linepointerjum.png"));

	lineToolButton2 = new QToolButton;
    lineToolButton2->setCheckable(true);
    lineToolButton2->setIcon(QIcon("images/linepointerjum.png"));

	lineToolButton3 = new QToolButton;
    lineToolButton3->setCheckable(true);
    lineToolButton3->setIcon(QIcon("images/linepointer.png"));

	erToolbar = new QToolBar(tr("E-R ToolBar"));
    erToolbar->addWidget(pointerToolButton);
    erToolbar->addWidget(tableToolButton);
    erToolbar->addWidget(lineToolButton1);
	//erToolbar->addWidget(lineToolButton2);
	erToolbar->addWidget(lineToolButton3);
			
	erTypeGroup = new QButtonGroup;
    erTypeGroup->addButton(pointerToolButton, int(Canvas::MoveItem));
	erTypeGroup->addButton(tableToolButton, 2);
    erTypeGroup->addButton(lineToolButton1, 3);
	//erTypeGroup->addButton(lineToolButton2, 4);
	erTypeGroup->addButton(lineToolButton3, 5);

	//erTypeGroup->addButton(textToolButton, 3);
    
	connect(erTypeGroup, SIGNAL(buttonClicked(int)),this, SLOT(PointerGroupClicked(int)));

}

void DrawERDlg::ItemInserted(Table* table)
{
	this->a = 1;
	this->canvas->SetMode(Canvas::Mode(1));
    erTypeGroup->button(2)->setChecked(false);
	erTypeGroup->button(1)->setChecked(true);
}

void DrawERDlg::ItemInserted(Arrow* arrow)
{
	this->a = 1;
	if(arrow->GetMode() == 1)
	{
		this->canvas->SetMode(Canvas::Mode(3));
		erTypeGroup->button(3)->setChecked(false);
		erTypeGroup->button(1)->setChecked(true);
	}
	else if(arrow->GetMode() == 2)
	{
		this->canvas->SetMode(Canvas::Mode(4));
		erTypeGroup->button(4)->setChecked(false);
		erTypeGroup->button(1)->setChecked(true);
	}
	else if(arrow->GetMode() == 3)
	{
		this->canvas->SetMode(Canvas::Mode(5));
		erTypeGroup->button(5)->setChecked(false);
		erTypeGroup->button(1)->setChecked(true);
	}
}

void DrawERDlg::PointerGroupClicked(int id)
{
	this->canvas->SetMode(Canvas::Mode(erTypeGroup->checkedId()));

	if(id == 4)
	{
		relaitonCardiMode = 4;
	}
	else
	{
		relaitonCardiMode = 0;
	}
}

void DrawERDlg::clickBack()
{
	accept ();
	
	IntroModeSelectDlg	*selectMode = new IntroModeSelectDlg();
	selectMode->exec();
}

void DrawERDlg::clickApply()
{
	qDebug() << "dddddddddd" << this;
	qDebug() << "a" << this->a;
	
	QString sqlString;
	QSqlQuery query;
	
	// ̺    ۼ  
	for(int i=0; i< this->tables.count(); i++){
		
		query = QSqlQuery(QString("drop table if exists " + (this->tables)[i]->getTableName() +";"));
		qDebug() << "dropTable:" << query.lastError();
		
		//qDebug() << QString("create table " + (this->tables)[i]->getTableName() + "(hanseungheuck int);");
		query = QSqlQuery(QString("create table " + (this->tables)[i]->getTableName() + "(hanseungheuck int) ENGINE=INNODB;"));
		qDebug() << "createTable:" << query.lastError();
		
		QString buffer;
		QStringList pk;
		
		for( int j=0; j<(this->tables)[i]->fieldInfo.count(); j++){
			
			buffer = QString("ALTER TABLE " + (this->tables)[i]->getTableName() );
			
			if( ((this->tables)[i]->fieldInfo)[j]->getNotNull() == 0 ){
				buffer += QString(" ADD " + ((this->tables)[i]->fieldInfo)[j]->getFieldName() + " " + 
					((this->tables)[i]->fieldInfo)[j]->getFieldDataType() +"(" +((this->tables)[i]->fieldInfo)[j]->getFieldLength() +")" + " NULL;");
			}
			else{
				buffer += QString(" ADD " + ((this->tables)[i]->fieldInfo)[j]->getFieldName() + " " + 
					((this->tables)[i]->fieldInfo)[j]->getFieldDataType() +"(" +((this->tables)[i]->fieldInfo)[j]->getFieldLength() +")" + " NOT NULL;;");
			}
			
			query = QSqlQuery(buffer);
			qDebug() << "addColumn:" << query.lastError();
			
			if( ((this->tables)[i]->fieldInfo)[j]->getPrimaryKey() == 1 ){
				pk << ((this->tables)[i]->fieldInfo)[j]->getFieldName();
			}
		}
		
		buffer = QString("ALTER TABLE "+ (this->tables)[i]->getTableName() + " ADD PRIMARY KEY (" );
		
		for( int j=0; j<pk.count(); j++){
			if( j != pk.count()-1 ){
				buffer += pk[j] + ", ";
			}
			else{
				buffer += pk[j];
			}
		}
		
		buffer += QString("); ");
		
		qDebug() << buffer;
		
		query = QSqlQuery(buffer);
		qDebug() << "primarykey:" << query.lastError();
		qDebug() << "PrimaryKey:" << query.lastError();
		
		query = QSqlQuery("ALTER TABLE " + (this->tables)[i]->getTableName() + " DROP COLUMN hanseungheuck;");
		qDebug() << "addColumn:" << query.lastError();
	}
	
	//     ۼ  
	for( int i=0; i<this->relationInfo.count() ; i++){
		
		qDebug() << "(this->relationInfo[i])->GetFkList().count()" << (this->relationInfo[i])->GetFkList().count();
		
		qDebug() << "RelationInfoCount:" << this->relationInfo.count();
		sqlString = QString("alter table " + (this->relationInfo)[i]->GetEndTableName() + " add constraint "
			+ (this->relationInfo)[i]->GetFkName() + " FOREIGN KEY (" );
		
		qDebug() << (this->relationInfo)[i]->GetFkList().count();
		
		for( int j=0; j<(this->relationInfo[i])->GetFkList().count(); j++ ){

			QString buffer = ((this->relationInfo)[i]->GetFkList())[j];

			if( buffer[buffer.count()-1] == ')' ){
				buffer = buffer.left(buffer.count() - 4);
			}

			qDebug() << "Buffer" << buffer;
			
			if( j != ((this->relationInfo)[i]->GetFkList().count()-1) ){
				sqlString += (this->relationInfo[i]->GetFkList())[j] + ", ";
			}
			else{
				sqlString += (this->relationInfo[i]->GetFkList())[j] + ") ";
			}	 
		}
		
		sqlString += "references " + (this->relationInfo)[i]->GetStartTableName() + " (";
		
		for( int j=0; j< (this->relationInfo[i])->GetFkList().count(); j++ ){

			QString buffer = ((this->relationInfo)[i]->GetFkList())[j];
			if( buffer[buffer.count()-1] == ')' ){
				buffer = buffer.left(buffer.count() - 4);
			}
			if( j != ((this->relationInfo)[i]->GetFkList().count()-1) ){
				sqlString += buffer + ", ";
			}
			else{
				sqlString += buffer;
			}	 
		}

		sqlString += ")";
		
		if( (this->relationInfo)[i]->GetState1() == 1 ){
			sqlString += " ON DELETE CASCADE";
		}
		
		if( (this->relationInfo)[i]->GetState2() == 1 ){
			//if( (this->relationInfo)[i]->GetState1() == 1 ){
				sqlString += " ON UPDATE CASCADE";
			//}
			//else{
			//	sqlString += " ON UPDATE CASCADE";
			//}
		}
		
		sqlString += ";";
		
		qDebug() << "";
		qDebug() << sqlString;
		query = QSqlQuery(sqlString);
		
		qDebug() << "Foreign Key : " << query.lastError();
	}
	
	this->close();
}

void DrawERDlg::clickCancel()
{
	QMessageBox::StandardButton closeMessage;
	closeMessage = QMessageBox::warning(this, tr(""),
		tr("̺ ⸦ մϴ.\n"
		" Ͻðڽϱ?"),
		QMessageBox::Yes | QMessageBox::No);
	
	if (closeMessage == QMessageBox::Yes)
		reject();
}
